#include <avr/sleep.h>
//#include <avr/interrupt.h>
#include <avr/power.h>
//#include <avr/wdt.h>
#include <math.h>


/*
 * You can specify TX_PIN here (before the line #include "ATtinySerialOut.hpp")
 */
 //#define TINY_SERIAL_DO_NOT_USE_115200BAUD 1

//#if defined(__AVR_ATtiny87__) || defined(__AVR_ATtiny167__)
//#define TX_PIN PA1 // (package pin 2 / TXD on Tiny167) - can use one of PA0 to PA7 here
//#else
//#define TX_PIN PB3 // can use one of PB0 to PB4 (+PB5) here
//#endif
//#include "ATtinySerialOut.hpp"


/*
   write1Start8Data1StopNoParityWithCliSei('I');
    writeBinary(tIndex);                    // 1 Byte binary output
    writeUnsignedByte(tIndex);              // 1-3 Byte ASCII output
    writeUnsignedByteHexWithPrefix(tIndex); // 4 Byte output
    writeUnsignedByteHex(tIndex);           // 2 Byte output
    write1Start8Data1StopNoParityWithCliSei('\n');
    PB4 = Pin 3 = ADC2 Sinus
    PB2 = Pin 7 = ADC1 Cosinus
    PB0 = Pin 5 = PCINT0 Windspeed
    PB3 = Pin 2 = Serial output
*/

#define PI 3.14159265
#define SINinputPin   4 // ADC2 Analog input SIN Winddirection
#define COSinputPin   2 // ADC1 Analog input COS Winddirection
#define WindSpeedPin  0 // Digital input WindSpeed INT0
#define SerialOutPin  3 // Same as TX_PIN above!!! <--- Serial output
#define notusedpin1   1


// Constants
#define DELAY      15

volatile int t_celsius;
volatile int old_t = 0;
double SIN, COS, result;
int subValue, minX, minY, maxX, maxY, degree;
int x, y;

byte saveADCSRA;
//volatile byte counterWD = 0; // Count how many times WDog has fired. Used in the timing of the




// ----------------------------------------------------------------
// We'll take advantage of the built in millis() timer that goes off
// to keep track of time, and refresh the servo every 20 milliseconds

volatile uint8_t counter = 0;
SIGNAL(TIMER0_COMPA_vect) {
  // this gets called every 2 milliseconds
  counter += 2;
  // every 20 milliseconds, refresh the servos!
  if (counter >= 20) {
    counter = 0;
    //myservo.refresh(); // DO THE SERVO NEED POWER DURING THIS??
  }
}


// Serial putc bitbanged 9600 baud
// 9600 Baud should be 1/9600 = 104us per bit
// So you need a good delay on 100uS

#define BAUD 380 // Should be 416uS for 2400 baud, 208-4800, 104-9600

void putch( char c ) {
  register unsigned char i;

  digitalWrite(SerialOutPin, 0); // Start bit
  //digitalWrite(SerialOutPin, 1); // Start bit INVERTED!
  delayMicroseconds(BAUD);
  //c = !(c);   // data = INVERTED!
  for (i = 8; i > 0; i--)
  {
    digitalWrite(SerialOutPin, c & 0x01);      // copy to TXD pin
    c >>= 1;
    delayMicroseconds(BAUD);
  }
  digitalWrite(SerialOutPin, 1); // Stop bit
  //digitalWrite(SerialOutPin, 0); // Stop bit INVERTED!
  delayMicroseconds(BAUD);
}


void putstr( unsigned char *s ) {
  register unsigned char c;

  while ( c = *s++ ) // wait for the \0 terminator
  {
    if (c == 10)
      putch('\r'); // add carrige return if line feed is found
    putch(c);
  }
}



const unsigned char nibble2hex[] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};

void print_byte_hex(unsigned char indata)
{
   putch( nibble2hex[0x0F & (indata>>4)] );
   putch( nibble2hex[0x0F & (indata)] );
}

/*
void print_crlf(void )
{
   putch(13);
   putch(10);
}



void print_byte_binary(unsigned char indata)
{
  register unsigned char i;

  putch('b');
  for (i=8; i>0; i++)
  {
    // if (indata & (0x01 << i) )
    if ((indata & 0x80) != 0)
      putch('1');
    else
      putch('0');
      indata = indata * 2; // remove option
    }
}


void print_word_dec(unsigned int indata)
{
   _print_universal_dec( indata, 10000, 5, 0);
}

void print_word_dec_1(unsigned int indata)
{
   _print_universal_dec( indata, 10000, 5, 1);
}

void print_byte_dec(unsigned char indata)
{
   _print_universal_dec( indata, 100, 3, 0);
}

void print_byte_2dec(unsigned char indata)
{
   _print_universal_dec( indata, 100, 2, 0);
}

void print_byte_dec_1(unsigned char indata)
{
   _print_universal_dec( indata, 100, 3, 1);
}

void _print_universal_dec(unsigned int indata, unsigned int digit_divisor, unsigned char digit_number, unsigned char decimals) {
   unsigned char digit, no_digits_printed_yet, number_of_digits = 0;

  if ( indata == 0 )   {
    if (digit_number > 2)
      putch(' ');
    putch(' ');
    putch('0');
    if (decimals != 0) {
      putch('.');
      putch('0');
    }
    return;
  }

  if (( indata < 10 ) && (decimals != 0) )
    putch('0');


  if (( indata < 10 ) && ( indata > 0 ) )
    putch(' ');


  no_digits_printed_yet = true;

  while (digit_divisor > 0)
  {
//    if ((decimals > 0) && (indata < 10))
    if ((decimals > 0) && (digit_divisor == 1))
      putch('.');
    digit = (unsigned char)  ( indata / digit_divisor );
    indata = indata % digit_divisor;
    digit_divisor = digit_divisor / 10;

    if ((digit != 0) | (no_digits_printed_yet == false)) {
      putch( digit | '0');
      no_digits_printed_yet = false;
    }
    digit_number--;
  }
}

*/

// Calibration of the temperature sensor has to be changed for your own ATtiny85
// per tech note: http://www.atmel.com/Images/doc8108.pdf
float chipTemp(float raw) {
  const float chipTempOffset = 272.9;           // Your value here, it may vary
  const float chipTempCoeff = 1.075;            // Your value here, it may vary
  return((raw - chipTempOffset) / chipTempCoeff);
}



// Common code for both sources of an ADC conversion
int getADC() {
  ADCSRA  |=_BV(ADSC);           // Start conversion
  while((ADCSRA & _BV(ADSC)));    // Wait until conversion is finished
  return ADC;
}



void resetWatchDog() {
  MCUSR = 0;
  WDTCR = bit ( WDCE ) | bit ( WDE ) | bit ( WDIF ); // allow changes, disable reset, clear existing interrupt
  WDTCR = bit ( WDIE ) | bit ( WDP3 )| bit ( WDP0 ); // set WDIE ( Interrupt only, no Reset ) and 8 second TimeOut
  //wdt_reset();                           // reset WDog to parameters

}


ISR (WDT_vect) {
  //wdt_disable ();                           // until next time....
}



void setup() {

  // Setup the Analog to Digital Converter -  one ADC conversion is read and discarded
  ADCSRA &= ~(_BV(ADATE) |_BV(ADIE)); // Clear auto Manual and interrupt enable
  ADCSRA |= _BV(ADEN);                // Enable AD and start conversion
  ADMUX = 0xF | _BV( REFS1 );         // ADC4 (Temp Sensor) and Ref voltage = 1.1V;
  delay(100);                         // Settling time min 1 ms, take 100 ms
  getADC();

//  initTXPin();


  putstr("OSCCAL=");
  print_byte_hex(OSCCAL);


  pinMode(SINinputPin, INPUT);
  pinMode(SerialOutPin, OUTPUT);
  pinMode(COSinputPin, INPUT);
  digitalWrite(WindSpeedPin, HIGH);
  pinMode(WindSpeedPin, INPUT_PULLUP);

  // Set up the interrupt for Wind speed
  //OCR0A = 0xAF;            // any number is OK
  //TIMSK |= _BV(OCIE0A);    // Turn on the compare interrupt

}




void loop() {
  //uint8_t vccIndex;
  //float rawTemp, rawVcc;
  char buffer[40];



  /*/ -------------------
  // Measure temperature

  ADCSRA |= _BV(ADEN);           // Enable AD and start conversion
  ADMUX = 0xF | _BV( REFS1 );    // ADC4 (Temp Sensor) and Ref voltage = 1.1V;
  delay(100);                    // Settling time min 1 ms, wait 100 ms

  rawTemp = (float)getADC();     // use next sample as initial average
  for (int i=2; i<1000; i++) {   // calculate running average for 1000 measurements
    rawTemp += ((float)getADC() - rawTemp) / float(i);
  }
  ADCSRA &= ~(_BV(ADEN));        // disable ADC


  // -------------------
  // Measure chip voltage (Vcc)

  ADCSRA |= _BV(ADEN);   // Enable ADC
  ADMUX  = 0x0c | _BV(REFS2);    // Use Vcc as voltage reference, bandgap reference as ADC input
  delay(100);                    // Settling time min 1 ms, there is time so wait 100 ms

  rawVcc = (float)getADC();      // use next sample as initial average
  for (int i=2; i<1000; i++) {   // calculate running average for 1000 measurements
    rawVcc += ((float)getADC() - rawVcc) / float(i);
  }
  ADCSRA &= ~(_BV(ADEN));        // disable ADC


  rawVcc = 1024 * 1.1f / rawVcc;    //index 0..13 for vcc 1.7 ... 3.0
  vccIndex = min(max(17,(uint8_t)(rawVcc * 10)),30) - 17;

  // Temperature compensation using the chip voltage
  // with 3.0 V VCC is 1 lower than measured with 1.7 V VCC
  t_celsius = (int)(chipTemp(rawTemp) + (float)vccIndex / 13);

  // still 10 degrees to much so decrease by 10 - not critical for this application really
  t_celsius -= 10;


  if (old_t != t_celsius) {  // We got a new temperature
    old_t = t_celsius;

  }
*/

  // ---------------------
  // Set up the interrupt
  OCR0A = 0xAF;            // any number is OK
  //TIMSK |= _BV(OCIE0A);    // Turn on the compare interrupt


  //--------------------------
  // Read Sinus value

#define LOOPS 250

  ADCSRA |= _BV(ADEN);                // Enable AD and start conversion
  ADMUX = 0x02;//  | _BV( REFS1 );    // ADC2 PB4 Ref voltage = Vcc
  delay(5);                           // Settling time

  SIN = (float)getADC();              // use next sample as initial average
  for (int i = 2; i < LOOPS; i++) {   // calculate running average for 1000 measurements
    SIN += (float)getADC();
  }
  SIN /= LOOPS;


  //--------------------------
  // Read Co-Sinus value

  //ADCSRA |= _BV(ADEN);
  ADMUX = 0x01 ;//| _BV( REFS1 );    // ADC1 PB2 and Ref voltage = 1.1V;
  delay(5);

  COS = (float)getADC();
  for (int i = 2; i < LOOPS; i++)  {
    COS += (float)getADC();
  }
  COS /= LOOPS;
  ADCSRA &= ~(_BV(ADEN));        // disable ADC

  y = COS - 512;
  x = SIN - 512;


  // Give the y,x to arctan2 function to give ur radians
  // but convert to degrees in the end...

  //putstr("Y = "); Serial.print(y);  putstr(" X = "); Serial.print(x);
  sprintf(buffer, "Y = %d  X = %d", y, x);
  putstr(buffer);

  result = atan2 (y,x) * 180 / PI;
  if (result < 0)
    result += 360;

  degree = result;

  // Return angle in degrees
  sprintf(buffer, " Degrees = %d\n", degree);
  putstr(buffer);

}
